/*------------------------------------------------------------------------------*
 * File Name: statEx_utils.h 													*
 * Creation: 11/23/2005, Max													*
 * Purpose: OriginC header file	for Advanced Statistics Functions				*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _STATEX_UTILS_H
#define _STATEX_UTILS_H
 

#include <ocStatEx.h>
#include <stats_types.h>


////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Define constants, enums, typedefs, and non-localized strings
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

/// Max 11/15/05 ADD_CONST_VARIABLES_FOR_RM_ANOVA
/*
#define MEANS_COMPARISON_METHODS_NUMBER		8	// number of means comparison methods
#define RM_ANOVA_ONE_WAY_TABLE_SIZE			10	// size of row elements for ANOVA table of RM ANOVA one way
#define RM_ANOVA_TWO_WAY_ONE_RV_TABLE_SIZE	15	// size of row elements for ANOVA table of RM ANOVA two way with one RV 
#define RM_ANOVA_TWO_WAY_TWO_RV_TABLE_SIZE	26	// size of row elements for ANOVA table of RM ANOVA two way with two RV
#define MULTIVARIATE_TEST_TABLE_SIZE		4	// size of row elements for Multivariate test table
*/
/// End ADD_CONST_VARIABLES_FOR_RM_ANOVA



////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
// Declare function prototypes
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////
//
//				Repeated Measure ANOVA Functions									
//
/////////////////////////////////////////////////////////////////////////////////
// Category last updated by Echo on 03/23/2007
/** >Statistics>Advanced

*/
int  stats_rm_anova_one_way(const MeanCompMethod& nIntervalType,
							const vector &vData,
				  			int nSizeSubject,
							int nGroupSize,
							double dAlpha, 
							int ncntrl,
							RMANOVADescStats* pDescStats, uint nSizeDescStat,
							RMANOVAOneWay *RMANOVATable, 
							MeanCompStats *pMeanCompStats, uint nSizeMeanComp,
							MultiTestTable *RVMultiStats,
							SphericityStats *RVSphericStats,
							EpsilonStats *RVEpsilonStats);

							
// Category last updated by Echo on 03/23/2007
/** >Statistics>Advanced

*/							
int stats_rm_anova_two_way_one_rv(const MeanCompMethod& nIntervalType,
							int iInteraction,
							const vector &vData,
							const vector<int> &vNonRVData,
							int nSizeSubject,
							int nRVGroupSize,
							int nNonRVGroupSize,
							double dAlpha, 
							int ncntrl1,
							int ncntrl2,
							RMANOVADescStats* pRVDescStats, uint nSizeRVDescStat,
							RMANOVADescStats* pNonRVDescStats, uint nSizeNonRVDescStat,
							RMANOVADescStats* pInterDescStats, uint nSizeInterDescStat,
							RMANOVATwoWayOneRV *RMANOVATable, 
							MeanCompStats *pRVMeanCompStats, uint nSizeRVMeanComp,
							MeanCompStats *pNonRVMeanCompStats, uint nSizeNonRVMeanComp,
							MeanCompStats *pFixNonRVMeanCompStats, uint nSizeFixNonRVMeanComp,
							MeanCompStats *pFixRVMeanCompStats, uint nSizeFixRVMeanComp,
							MultiTestTable *RVMultiStats,
							MultiTestTable *InterMultiStats,
							SphericityStats *RVSphericStats,
							EpsilonStats *RVEpsilonStats);							

							
// Category last updated by Echo on 03/23/2007
/** >Statistics>Advanced

*/
int stats_rm_anova_two_way_two_rv(const MeanCompMethod& nIntervalType,
							int iInteraction,
							const vector &vData,
							int nSizeSubject,
							int nGroupSize,
							int nRV1Levels,
							int nRV2Levels,
							double dAlpha, 
							int ncntrl1,
							int ncntrl2,
							RMANOVADescStats* pRV1DescStats, uint nSizeRV1DescStat,
							RMANOVADescStats* pRV2DescStats, uint nSizeRV2DescStat,
							RMANOVADescStats* pInterDescStats, uint nSizeInterDescStat,
							RMANOVATwoWayTwoRV *RMANOVATable, 
							MeanCompStats *pRV1MeanCompStats, uint nSizeRV1MeanComp,
							MeanCompStats *pRV2MeanCompStats, uint nSizeRV2MeanComp,
							MeanCompStats *pFixRV2MeanCompStats, uint nSizeFixRV2MeanComp,
							MeanCompStats *pFixRV1MeanCompStats, uint nSizeFixRV1MeanComp,
							MultiTestTable *RV1MultiStats,
							MultiTestTable *RV2MultiStats,
							MultiTestTable *InterMultiStats,
							SphericityStats *RV1SphericStats,
							SphericityStats *RV2SphericStats,
							SphericityStats *InterSphericStats,
							EpsilonStats *RV1EpsilonStats,
							EpsilonStats *RV2EpsilonStats,
							EpsilonStats *InterEpsilonStats);
							
							

#endif // _STATEX_UTILS_H